<?php

// admin/login.php
session_start();
require_once "../config/db.php"; // Asegúrate de que la ruta a db.php sea correcta

$error = '';

// Si ya está logueado, mandar al dashboard
if (isset($_SESSION['user_id'])) {
    header("Location: dashboard.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    if (empty($email) || empty($password)) {
        $error = "Por favor ingrese todos los campos.";
    } else {
        // Buscar usuario en la BD (Asumiendo tabla 'users' o 'admins')
        $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email LIMIT 1");
        $stmt->execute(['email' => $email]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        // Verificar contraseña (usando password_verify para seguridad)
        if ($user && password_verify($password, $user['password_hash'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['full_name']; // Antes decía 'name'
            $_SESSION['user_role'] = $user['role'];

            header("Location: dashboard.php");
            exit;
        } else {
            $error = "Credenciales incorrectas. Intenta de nuevo.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Admin | JFD Importaciones</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;600;800;900&family=Roboto:wght@300;400;500&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Roboto', 'sans-serif'],
                        display: ['Barlow', 'sans-serif'],
                    },
                    colors: {
                        brand: {
                            black: '#050505',
                            dark: '#121212',
                            red: '#D90429',
                            red_hover: '#EF233C',
                            yellow: '#FFD60A',
                        }
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-50 dark:bg-brand-black transition-colors duration-300">

    <div class="min-h-screen flex items-center justify-center p-4 relative overflow-hidden">
        
        <div class="absolute inset-0 z-0">
            <div class="absolute top-0 left-0 w-full h-full bg-[url('https://www.transparenttextures.com/patterns/carbon-fibre.png')] opacity-5 dark:opacity-20"></div>
            <div class="absolute -top-20 -right-20 w-96 h-96 bg-brand-red/10 rounded-full blur-3xl"></div>
            <div class="absolute bottom-0 left-0 w-full h-1/2 bg-gradient-to-t from-brand-black/10 to-transparent"></div>
        </div>

        <div class="relative z-10 w-full max-w-md bg-white dark:bg-brand-dark rounded-2xl shadow-2xl border border-gray-100 dark:border-white/5 overflow-hidden">
            
            <div class="p-8 pb-0 text-center">
                <div class="mb-6 flex justify-center">
                    <img id="login-logo" src="../public/img/logo-jfd.png" alt="JFD Logo" class="h-20 object-contain transition-all duration-300">
                </div>
                <h1 class="font-display font-black text-3xl text-gray-900 dark:text-white uppercase tracking-tight">
                    Panel <span class="text-brand-red">Admin</span>
                </h1>
                <p class="text-gray-500 dark:text-gray-400 text-sm mt-2">Acceso exclusivo para personal autorizado</p>
            </div>

            <div class="p-8 pt-6">
                
                <?php if($error): ?>
                    <div class="mb-6 p-4 rounded-lg bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 flex items-center gap-3">
                        <i class="ri-error-warning-fill text-brand-red text-xl"></i>
                        <p class="text-sm text-red-700 dark:text-red-400 font-medium"><?php echo $error; ?></p>
                    </div>
                <?php endif; ?>

                <form method="POST" action="" class="space-y-6">
                    <div>
                        <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Correo Electrónico</label>
                        <div class="relative group">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-gray-400 group-focus-within:text-brand-red transition-colors">
                                <i class="ri-mail-fill text-lg"></i>
                            </span>
                            <input type="email" name="email" required 
                                class="w-full pl-10 pr-4 py-3 bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:border-brand-red focus:ring-1 focus:ring-brand-red transition-all"
                                placeholder="admin@jfd.pro">
                        </div>
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-gray-400 uppercase tracking-widest mb-2">Contraseña</label>
                        <div class="relative group">
                            <span class="absolute inset-y-0 left-0 flex items-center pl-3 text-gray-400 group-focus-within:text-brand-red transition-colors">
                                <i class="ri-lock-password-fill text-lg"></i>
                            </span>
                            <input type="password" name="password" required 
                                class="w-full pl-10 pr-4 py-3 bg-gray-50 dark:bg-black/50 border border-gray-200 dark:border-white/10 rounded-lg text-gray-900 dark:text-white placeholder-gray-400 focus:outline-none focus:border-brand-red focus:ring-1 focus:ring-brand-red transition-all"
                                placeholder="••••••••">
                        </div>
                    </div>

                    <button type="submit" 
                        class="w-full bg-brand-red hover:bg-brand-red_hover text-white font-display font-bold text-lg uppercase tracking-widest py-3 rounded-lg shadow-lg shadow-brand-red/20 hover:shadow-brand-red/40 transition-all transform active:scale-95 flex items-center justify-center gap-2">
                        Ingresar <i class="ri-arrow-right-line"></i>
                    </button>
                </form>

                <div class="mt-8 text-center border-t border-gray-100 dark:border-white/5 pt-6">
                    <a href="../index.php" class="text-sm font-medium text-gray-500 hover:text-brand-red transition-colors flex items-center justify-center gap-2">
                        <i class="ri-arrow-left-line"></i> Volver al sitio web
                    </a>
                </div>
            </div>
        </div>
        
        <div class="absolute bottom-4 text-center w-full">
            <p class="text-[10px] text-gray-400 font-display uppercase tracking-widest">
                &copy; 2026 JFD Audio Profesional
            </p>
        </div>

    </div>

    <script>
        const themeBtn = document.getElementById('theme-btn');
        const html = document.documentElement;
        const loginLogo = document.getElementById('login-logo');

        // Función para cambiar el logo
        function updateLogo() {
            if (!loginLogo) return;
            
            // Efecto suave
            loginLogo.style.opacity = '0.5';
            
            setTimeout(() => {
                if (html.classList.contains('dark')) {
                    loginLogo.src = '../public/img/logo-jfd.png';
                } else {
                    loginLogo.src = '../public/img/logo-jfd-dark.png';
                }
                loginLogo.style.opacity = '1';
            }, 150);
        }

        // Inicializar
        if (localStorage.getItem('theme') === 'light') {
            html.classList.remove('dark');
        } else {
            html.classList.add('dark');
        }
        updateLogo();

        // Evento Switch
        themeBtn.addEventListener('click', () => {
            if (html.classList.contains('dark')) {
                html.classList.remove('dark');
                localStorage.setItem('theme', 'light');
            } else {
                html.classList.add('dark');
                localStorage.setItem('theme', 'dark');
            }
            updateLogo();
        });
    </script>
</body>
</html>